/* Russian encodings with care to letter YO from www.rusf.ru/books/yo */
/* Written by 2002 D.V.Khmelev */

/*  !!!!!!!!!!!!    BEFORE COMPILATION !!!!!!!!!!!!!!!!!!!!!!!!!!!    */
/* Please #define D_ALT for messages in cp866                         */
/* Please #define D_KOI for messages in koi8-r                        */
/* You can also pass their definitions through compiler command line  */
/*  gcc -DD_KOI xcode.c -o xcode   #GNU C compiler                    */
/*  bcc.exe -DD_KOI xcode.c        #Borland C compiler                */

//       // Output encoding by default
#define __ENCLINE__ __LINE__
//#define D_ALT
//#define D_WIN
//#define D_KOI
//#define D_ISO
//#define D_MAC

#ifdef D_ALT
# define OUTPUT_ENC 0 
  //  "" (.. ) //either cp866
#elif defined(D_WIN)
# define OUTPUT_ENC 1  // win=cp1251
#elif defined(D_KOI)
#  define OUTPUT_ENC 2  //  "KOI". // or koi8
#elif defined(D_ISO)
#  define OUTPUT_ENC 3  // iso
#elif defined(D_MAC)
#  define OUTPUT_ENC 4  // mac
#else
#  error Please #define default output encoding D_ALT D_WIN D_KOI D_ISO D_MAC 
#endif

// Change Log:
// $Log: xcode.c,v $
// Revision 2.6  2003/03/10 17:36:26  mamont
//    silent   
//
// Revision 2.5  2003/03/10 17:30:05  mamont
//   silent   -s
//
// Revision 2.4  2003/03/09 01:42:47  mamont
//       
//
// Revision 2.3  2003/03/08 19:57:28  mamont
//    bc 3.1    .
//
// Revision 2.2  2003/03/08 19:33:27  mamont
//        /. (/Win
//    D_ALT)
//
// Revision 2.1  2003/03/08 19:25:05  mamont
// *** empty log message ***
//
// Revision 2.0  2003/03/08 19:23:31  mamont
//     2.0
//
// Revision 1.14  2003/03/08 19:13:24  mamont
//       . 
//     -p,      
//    .
//
//     ,     ţ
// ,    .  
// :      .   
//     ,   .
//
// Revision 1.13  2003/03/08 16:24:13  mamont
//  Revision
//
// Revision 1.12  2003/03/08 16:17:35  mamont
//   
//

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>
#include <sys/stat.h> 

#define XCODE "xcode"
#define REVISION "$Revision: 2.6 $"
static char * VERSIONR=REVISION;
static char VERSION[100];//=VERSIONR+11

#define SELF_URL_BASE "http://www.rusf.ru/books/yo"
#define SELF_URL SELF_URL_BASE "/src/xcode.c"



/*      ,    */
/*   14      . */

/*   Functions for C, providing exchange transformation of */
/*   14 russian encodings to each other. */

/*    : ..̣,  2002 */
/*   : http://www.rusf.ru/books/yo */

/*      -ware, ,     */
/*   ,       ,    */
/*    . ,   ,      */
/*      ,    :    */
/*         . */

/*   This code was written by D.V.Khmelev, March 2002 */
/*   More information at http://www.rusf.ru/books/yo */

/*   The following code is YO-ware. YO-ware means that you can freely copy, */
/*   modify and disassemble it in binary and/or source text. */
/*   However, if you use this program code, you should use Russian letter YO */
/*   in all texts in Russian you type in computer from e-mails */
/*   to novells. */

typedef enum {
  CP866=0,
  CP1251,
  KOI8_R,
  ISO8859_5,
  MAC,
  OSN,
  MOSHKOV,
  SORT,
  ALT_FIDO,
  KOI7,
  DKOI,
  CP500,
  EBCDIC,
  ASCII,
  TOTAL_ENCODING_NUMBER} encoding_t;

char * encoding_name[]={
  "cp866", /* CP866 */
  "cp1251", /* CP1251 */
  "koi8-r", /* KOI8_R */
  "iso8859-5", /* ISO8859_5 */
  "mac", /* MAC */
  "osn", /* OSN */
  "moshkov", /* MOSHKOV */
  "sort", /* SORT */
  "alt-fido", /* ALT_FIDO */
  "koi7", /* KOI7 */
  "dkoi", /* DKOI */
  "cp500", /* CP500 */
  "ebcdic", /* EBCDIC */
  "ascii", /* ASCII */
};
unsigned char * encoding_alphabet[]={
  /* CP866 */
  "\240\241\242\243\244\245\361\246\247\250"
  "\251\252\253\254\255\256\257\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\200\201\202\203\204\205\360\206\207\210"
  "\211\212\213\214\215\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* CP1251 */
  "\340\341\342\343\344\345\270\346\347\350"
  "\351\352\353\354\355\356\357\360\361\362"
  "\363\364\365\366\367\370\371\372\373\374"
  "\375\376\377"
  "\300\301\302\303\304\305\250\306\307\310"
  "\311\312\313\314\315\316\317\320\321\322"
  "\323\324\325\326\327\330\331\332\333\334"
  "\335\336\337",
  /* KOI8_R */
  "\301\302\327\307\304\305\243\326\332\311"
  "\312\313\314\315\316\317\320\322\323\324"
  "\325\306\310\303\336\333\335\337\331\330"
  "\334\300\321"
  "\341\342\367\347\344\345\263\366\372\351"
  "\352\353\354\355\356\357\360\362\363\364"
  "\365\346\350\343\376\373\375\377\371\370"
  "\374\340\361",
  /* ISO8859_5 */
  "\320\321\322\323\324\325\361\326\327\330"
  "\331\332\333\334\335\336\337\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\260\261\262\263\264\265\241\266\267\270"
  "\271\272\273\274\275\276\277\300\301\302"
  "\303\304\305\306\307\310\311\312\313\314"
  "\315\316\317",
  /* MAC */
  "\340\341\342\343\344\345\336\346\347\350"
  "\351\352\353\354\355\356\357\360\361\362"
  "\363\364\365\366\367\370\371\372\373\374"
  "\375\376\377"
  "\200\201\202\203\204\205\335\206\207\210"
  "\211\212\213\214\215\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* OSN */
  "\320\321\322\323\324\325\361\326\327\330"
  "\331\332\333\334\335\336\337\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\260\261\262\263\264\265\360\266\267\270"
  "\271\272\273\274\275\276\277\300\301\302"
  "\303\304\305\306\307\310\311\312\313\314"
  "\315\316\317",
  /* MOSHKOV */
  "\341\342\367\347\344\345\243\366\372\351"
  "\352\353\354\355\356\357\360\362\363\364"
  "\365\346\350\343\376\373\375\256\371\370"
  "\374\340\361"
  "\301\302\327\307\304\305\263\326\332\311"
  "\312\313\314\315\316\317\320\322\323\324"
  "\325\306\310\303\336\333\335\254\331\330"
  "\334\300\321",
  /* SORT */
  "\241\242\243\244\245\246\247\250\251\252"
  "\253\254\255\256\257\260\261\262\263\264"
  "\265\266\267\270\271\272\273\274\275\276"
  "\277\300\301"
  "\200\201\202\203\204\205\206\207\210\211"
  "\212\213\214\215\216\217\220\221\222\223"
  "\224\225\226\227\230\231\232\233\234\235"
  "\236\237\240",
  /* ALT_FIDO */
  "\240\241\242\243\244\245\361\246\247\250"
  "\251\252\253\254\255\256\257\160\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\200\201\202\203\204\205\360\206\207\210"
  "\211\212\213\214\110\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* KOI7 */
  "\101\102\127\107\104\105\43\126\132\111"
  "\112\113\114\115\116\117\120\122\123\124"
  "\125\106\110\103\136\133\135\137\131\130"
  "\134\100\121"
  "\141\142\167\147\144\145\44\166\172\151"
  "\152\153\154\155\156\157\160\162\163\164"
  "\165\146\150\143\176\173\175\42\171\170"
  "\174\140\161",
  /* DKOI */
  "\167\170\257\215\212\213\131\256\262\217"
  "\220\232\233\234\235\236\237\252\253\254"
  "\255\214\216\200\266\263\265\267\261\260"
  "\264\166\240"
  "\271\272\355\277\274\275\102\354\372\313"
  "\314\315\316\317\332\333\334\336\337\352"
  "\353\276\312\273\376\373\375\165\357\356"
  "\374\270\335",
  /* CP500 */
  "\254\151\355\356\353\357\111\354\277\200"
  "\375\376\373\374\255\256\131\104\105\102"
  "\106\103\107\234\110\124\121\122\123\130"
  "\125\126\127"
  "\220\217\352\372\276\240\252\266\263\235"
  "\332\233\213\267\270\271\253\144\145\142"
  "\146\143\147\236\150\164\161\162\163\170"
  "\165\166\167",
  /* EBCDIC */
  "\237\240\252\253\254\255\335\256\257\260"
  "\261\262\263\264\265\266\267\270\271\272"
  "\273\274\275\276\277\312\313\314\315\316"
  "\317\332\333"
  "\130\131\142\143\144\145\102\146\147\150"
  "\151\160\161\162\163\164\165\166\167\170"
  "\200\212\213\214\215\216\217\220\232\233"
  "\234\235\236",
  /* ASCII */
  "\141\142\167\147\144\145\136\166\172\151"
  "\152\153\154\155\156\157\160\162\163\164"
  "\165\146\150\143\75\133\135\43\171\170"
  "\134\140\161"
  "\101\102\127\107\104\105\46\126\132\111"
  "\112\113\114\115\116\117\120\122\123\124"
  "\125\106\110\103\53\173\175\44\131\130"
  "\174\176\121",
};

int *full_encoding_list(encoding_t encoding, int table[]){
  int i,j;
  static int exists[256];
  for(i=0;i<256;i++) exists[i]=0;
  for(i=0;i<66;i++) {
    table[i]=encoding_alphabet[encoding][i];
    exists[table[i]]=1;
  }
  for(j=66,i=0;i<256;i++){
    if(exists[i]) continue;
    table[j++]=i;
  }
  return table;
}


int *fill_recode_table(int table[],encoding_t from, encoding_t to){
  static int full_enc_from[256];
  static int full_enc_to[256];
  int i;
  full_encoding_list(from,full_enc_from);
  full_encoding_list(to,full_enc_to);
  for(i=0;i<256;i++)
    table[full_enc_from[i]]=full_enc_to[i];
  return table;
}

unsigned char *srecode(unsigned char *s, encoding_t from, encoding_t to){
  static int prev_from=-1, prev_to=-1;
  static int recode_table[256]; 
  int i;
  if((from!=prev_from)||(to!=prev_to)){
    prev_from=from; prev_to=to;
    fill_recode_table(recode_table,from,to);
  }
  for(i=0;s[i];i++) s[i]=recode_table[s[i]];
  return s;
}

unsigned char *srecode2(unsigned char *s, unsigned char *t, encoding_t from, encoding_t to){
  static int prev_from=-1, prev_to=-1;
  static int recode_table[256]; 
  int i;
  if((from!=prev_from)||(to!=prev_to)){
    prev_from=from; prev_to=to;
    fill_recode_table(recode_table,from,to);
  }
  for(i=0;t[i];i++) s[i]=recode_table[t[i]];
  s[i]=0;
  return s;
}

#define NUMCOD 5

char  encLetter[]={'a','w','k','i','m'};


int enc=OUTPUT_ENC;
int program_output_encoding=OUTPUT_ENC;

int Russian=1;

unsigned char *alphabet=
  "ţ"; 

int self_encoding=2; //   ---    koi
void determine_self_encoding(char *selfname){
  for(self_encoding=0; 
      self_encoding<TOTAL_ENCODING_NUMBER;
      self_encoding++)
    if(strcmp(alphabet,encoding_alphabet[self_encoding])==0) return;
  Russian=0;
  self_encoding=2;
  fprintf(stderr,
    "WARNING: This version of %s has passed incorrect change of \n"
	  "WARNING: russian letters encoding!!!\n"
	  "WARNING: Download correct version from " SELF_URL "\n",
	  selfname);
}

static char temps[1500];

char *_rec(char *s){
  return srecode2(temps,s,self_encoding,program_output_encoding);
}


char *msgs_eng[]={
/*   msg_descr */
  "(Based on a program written originally by Andrey V. Lukyanov, May 14, 1997,\n"
  "and updated later by Cyril Rotmistrovsky and Igor V. Krassikov)\n"
  "\n"
  "This program tries to determine input document encoding\n"
  "and to convert it into a desired one.\n"
  "The important feature of this program is ONE-TO-ONE conversion,\n"
  "which prevents you from damaging your file. If conversion is\n"
  "incorrect or if you even converted a binary file, you can always\n"
  "RESTORE source file by backward conversion (if you did not use\n"
  "options -q and -t)\n"
  "\n"
  "This program is YO-ware. YO-ware means that you can freely copy,\n"
  "modify and disassemble in binary and/or source text.\n"
  "However, if you use this program, you should use Russian letter YO\n"
  "in all texts in Russian you type in computer from e-mails\n"
  "to novels.\n"
  "\n",
/* msg_encodings */
  "The following switches could be used for input "
  "and output encoding. \nHowever, "
  "automatic recognition is supported for first 5 encodings only.\n"
  "More information can be found at \n"
  "           " SELF_URL_BASE "/xcode.html\n",
/* msg_version */
  "Program "XCODE" version %s written by D.V.Khmelev\n"
  "(see http://www.rusf.ru/books/yo/xcode.html for details)\n",
/* msg_help */
  "Usage:\n"
  " "XCODE" -E -[hH?] -[wkaim1234567890] +[wkaim1234567890] [-q] [in [out]]\n"
  "-E -h in English (don't forget to add -h or -H switch!)\n"
  "-v print version information\n"
  "-H print help, list of 14 (fourteen) encodings supported\n"
  "   and view YO-ware license\n"
  "-q quoted-printable decoding (useful for decoding MIME-files)\n"
  "-t do unix2dos transformation (convert LF to CR/LF)\n"
  "-p pipe mode (applies to DOS/Win environment only)\n"
  "-s silent mode (no information on encodings displayed)\n"
  "If input/output files are not specified, the standard input/output is used.\n",
/* msg_out */
  "-%c to set   %-10s output", 
/* msg_forc */
  "+%c to force %-10s input\n",
/* msg_defl */
  " (default)\n",
/* msg_info */
  "-%d to set   %-10s output  +%d to set %-10s input\n",
/* msg_err_temp_file */
  "Unable to create temporary file. No free space on disk?\n",
/* msg_guessinp */
  "Guessed input encoding: %s\n",
/* msg_forceinp */
  "Forced input encoding: %s\n",
/* msg_outpenc */
  "Output encoding: %s\n",
/* msg_erropenfile */
  "Unable to open output file %s\n",
/* msg_err_in_file */
  "Unable to open input file %s\n",
/* msg_cant_write_temp_file */
  "Can't write to temporary file. Disk full?\n",
/* msg_pipe */
  "To use pipe mode run the program with option -p\n",
/* msg_tryhelp */
  "Try `xcode -e -h' for more information.\n",
};

char *msgs_rus[]={
/*   msg_descr */
  "(  ,    .  14.05.1997,\n"
  "        . )\n"
  "\n"
  "     \n"
  "     ,  .\n"
  "      ,\n"
  "     .   \n"
  ",       ,   \n"
  "     (, , \n"
  "    -q  -t).\n"
  "\n"
  "  -ware, , ţ   \n"
  ",       ,   \n"
  " . ,   ,  \n"
  "     ,    :\n"
  "        .\n"
  "\n",
/* msg_encodings */
  "       "
  ". \n, "
  "       5.\n"
  "  .   \n"
  "           " SELF_URL_BASE "/xcode.html\n",
/* msg_version */
  " "XCODE"  %s  ..̣\n"
  "( . http://www.rusf.ru/books/yo/xcode.html)\n",
/* msg_help */
  ": \n"
  " "XCODE" -E -[hH?] -[wkaim1234567890] +[wkaim1234567890] [-q] "
  "[in [out]]\n"
  "-E -h in English (don't forget to add -h or -H switch!)\n"
  "-v   \n"
  "-H  ,  14 ()  \n"
  "      -ware\n"
  "-q  \"quoted-pritable\" ,   MIME\n"
  "-t  unix2dos  ( LF  CR/LF)\n"
  "-p   (   DOS/Win )\n"
  "-s  silent ---     \n"
  " /   ,   /.\n",
/* msg_out */
  "-%c    %-10s ",
/* msg_forc */
  "+%c    %-10s \n",
/* msg_defl */
  " ( ) \n",
/* msg_info */
  "-%d    %-10s   +%d   %-10s\n",
/* msg_err_temp_file */
  "    .    ?\n",
/* msg_guessinp */
  "   %s\n",
/* msg_forceinp */
  "     %s\n",
/* msg_outpenc */
  "  %s\n",
/* msg_erropenfile */
  "     %s\n",
/* msg_err_in_file */
  "     %s\n",
/* msg_cant_write_temp_file */
  "     .  ?\n",
/* msg_pipe */
  "         -p\n",
/* msg_tryhelp */
  "  `"XCODE" -h'    .\n",
};


typedef enum{msg_descr, msg_encodings,msg_version,msg_help,msg_out,
	       msg_forc,msg_defl,msg_info, msg_err_temp_file, msg_guessinp,
	       msg_forceinp, msg_outpenc, msg_erropenfile,msg_err_in_file,
	       msg_cant_write_temp_file,msg_pipe,msg_tryhelp,
	       msg_last} msg_id;
char *msg(msg_id id){
  assert(id<msg_last);
  if(Russian) return _rec(msgs_rus[id]);
  return _rec(msgs_eng[id]);
}

void print_version(void){
  char *r;

  strcpy(VERSION,VERSIONR+11);
  r=strchr(VERSION,' ');
  *r=0;
  printf(msg(msg_version),VERSION);
  exit(0);
}

void print_short_help(void){
  int j;

  printf(msg(msg_help));
  for(j=0;j<NUMCOD;j++){
    printf(msg(msg_out),encLetter[j], encoding_name[j]);
    if(j!=enc) printf("\n");
    else printf(msg(msg_defl));
  }
  for(j=0;j<NUMCOD;j++){
    printf(msg(msg_forc),encLetter[j], encoding_name[j]);
  }
}
void print_long_help(void){
 int j;

  print_short_help();
  printf(msg(msg_descr));
  printf(msg(msg_encodings));
  for(j=0;j<TOTAL_ENCODING_NUMBER;j++){
    printf(msg(msg_info),
	   j+1,encoding_name[j],j+1,encoding_name[j]);
  }
}

unsigned char recode_table[NUMCOD][128]={
	{ //dos
	225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	128,129,130,131,132,133,134,135,136,137,186,139,140,141,142,143,
	144,145,146,147,148,149,150,151,152,153,154,191,156,157,158,159,
	160,161,162,176,164,165,166,167,168,169,170,171,172,173,174,175,
	210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
	179,163,'+','+','+','+','+','+',184,'+','+','+','+','+',190,' '
	},
	{ //win
	'+','+', 39,'+', 34,'+','+','+','+','+','+', 39,'+','+','+','+',
	'+', 39, 39, 34, 34,'+','+','-','-','*','+', 39,'+','+','+','+',
	' ','+','I','+','+','+','+','+',179,188,'E', 34,'+','+','*','I',
	184,'+','i',199,'*','*','*','*',163,'N','e', 34,'j','S','s','i',
	225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209
	},
	{   //koi8
	128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
	144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
	160,161,162,163,164,165,166,167,168,169,170,171,172,'-',174,175,
	176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
	192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
	208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
	224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
	240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
	},
	{ //iso
	'+','+','+','+','+','+','+','+','+','+','+','+','+','+','+','+',
	'+','+','+','+','+','+','+','+','+','+','+','+','+','+','+','+',
	'*',179,'*','*','*','*','*','*','*','*','*','*','*','*','*','*',
	225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209,
	'*',163,'*','*','*','*','*','*','*','*','*','*','*','*','*','*'
	},
	{ //mac
	225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
	242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
	'*',184,'*','*','*','*','*','I','*','*','*','*','*','*','*','*',
	'*',179,177,178,'i','*',199,'J','E','e','I','i','*','*','*','*',
	'j','S','*','*','f','*','*','*','*','*','*','*','*','*','*','s',
	'-','-', 34, 34, 39, 39,'*', 39,'*','*','*','*','N',163,179,209,
	193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
	210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,'*'
	}
};
int letter_frequency[32]=
{
	125,1606,331,65,598,1714,22,356,168,1312,206,636,1050,658,1295,2259,
	544,447,887,1049,1217,572,200,823,398,400,355,168,67,78,285,4
};

int work_recode_table[256];

double  rating[NUMCOD];

// Added by KIV
// Yes, we have Quoted-Printable...
// Disabled by Dima Khmelev
// No, no Quoted-Printable (very annoying when recode html files)
int hasQP = 0;

int getQP(int first, int second)
{
  if (!isdigit(first)) first  = toupper(first)  - 'A' + 1 +'9';
  if (!isdigit(second)) second = toupper(second) - 'A' + 1 +'9';
  return (first-'0')*16 + (second-'0');
};

int fput_recode_table[256];

void fput_and_value_c(int c, FILE*f){
  int i;
  if(c>=128)
    for(i=0; i<NUMCOD; i++)
      if(recode_table[i][c-128]>=192)
	rating[i]+=letter_frequency
	  [((int)recode_table[i][c-128]-192)%32];
  if(putc(fput_recode_table[c],f)==EOF){
    fprintf(stderr,msg(msg_cant_write_temp_file));
    fclose(f);
    exit(1);
  }
}

void read_qp(FILE*in,FILE*out){
  enum {scan, eq, dig} state;
  int c;
  int dig1;
  state=scan;
  for(;;){
    c=fgetc(in);
    if(state==scan){
      if(c==EOF){return;}
      if(c=='='){state=eq; continue;}
      fput_and_value_c(c,out);
      continue;
    }
    if(state==eq){
      if(c==EOF){ fput_and_value_c('=', out); return;}
      if(isxdigit(c)){ dig1=c; state=dig; continue;}
      if(c=='\r'){//  .
	c=fgetc(in);
	if(c=='\n'){
	  state=scan; continue;
	}
	fput_and_value_c('=', out);
	fput_and_value_c('\r', out);
	fput_and_value_c(c, out);
	continue;
      }
      if(c=='\n'){state=scan; continue;}
      fput_and_value_c('=',out);
      fput_and_value_c(c,out);
      state=scan;
      continue;
    }
    if(state==dig){
      if(c==EOF){ fput_and_value_c('=', out); fput_and_value_c(dig1, out); return;}
      if(isxdigit(c)){ 
	int cc=getQP(dig1,c);
	fput_and_value_c(cc,out); 
	state=scan; 
	continue;
      }
      fput_and_value_c('=', out); 
      fput_and_value_c(dig1, out);
      fput_and_value_c(c,out);
      state=scan;
      continue;
    }
  }
}

void read_file(FILE*in, FILE*out){
  int c;
  while((c=fgetc(in))!=EOF)
      fput_and_value_c(c,out);
}
FILE* openout(char*outfname,FILE*out,char*wt){
  if(outfname){
    out=fopen(outfname,wt);
    if(!out){
      fprintf(stderr,msg(msg_erropenfile),outfname);
      exit(1);
    }
  }
  return out;
}

int do_recode(char*fname, char*outfname, 
	      int enc, int force, int chkQP, char*wt,
	      int samefile, int silent){
  int c=0, a=0, i, j; 
  int     decide[NUMCOD];
  FILE *f,*out=stdout,*in=stdin; 
  if(fname) {
    in=fopen(fname,"rb");
    if(!in){
      fprintf(stderr,msg(msg_err_in_file),fname);
      return 1;
    }
  }

  fill_recode_table(fput_recode_table,0,0);

  if(force>=0){
    fill_recode_table(fput_recode_table,force,enc);
    if(!silent){
      fprintf(stderr,msg(msg_forceinp),encoding_name[force]);
      fprintf(stderr,msg(msg_outpenc),encoding_name[enc]);
    }
    if(samefile){
      f=tmpfile();
      if(chkQP)
	read_qp(in,f);
      else
	read_file(in,f);
      fclose(in);
      rewind(f);
      out=openout(outfname,out,wt);
      while((c=getc(f))!=EOF){
	putc(c,out);
      }
      fclose(f);
      fclose(out);
    }else if(outfname){
      out=openout(outfname,out,wt);
      if(chkQP)
	read_qp(in,out);
      else
	read_file(in,out);
      fclose(in); 
      fclose(out);
    }

    return 1;
  }

  for(i=0; i<NUMCOD; i++){ decide[i]=1; rating[i]=0;}
  
  f=tmpfile();
  if(f==NULL){ 
      fprintf(stderr,msg(msg_err_temp_file));
      return 1;
  }

  if(chkQP)
    read_qp(in,f);
  else
    read_file(in,f);

  fclose(in);

  for(i=0; i<NUMCOD; i++)
    for(j=0; j<NUMCOD; j++)
      if(i!=j && rating[i]<rating[j]) decide[i]=0;

  for(i=NUMCOD-1; i>=0; i--) if(decide[i]) a=i;
  if(!silent)
  {
    fprintf(stderr,msg(msg_guessinp),encoding_name[a]);
    fprintf(stderr,msg(msg_outpenc),encoding_name[enc]);
  }
  
  fill_recode_table(work_recode_table,a,enc);
  rewind(f);

  out=openout(outfname,out,wt);
  
  while((c=getc(f))!=EOF){
    putc(work_recode_table[c],out);
  }
  fclose(f);
  fclose(out);
  return 0;

}

int samebuf(struct stat *a,struct stat *b){
  return (a->st_size==b->st_size)
    &&   (a->st_mtime==b->st_mtime);
}

int main(int argc,char ** argv)
{
  char *wt="wb";
  int force=-1;
  int chkQP=0;
  int samefile;
  int do_pipe=0;
  int silent=0;
  char *filename;
  char *outfname;
  int version=0,help=0,Help=0;

  int I=0;
  
  determine_self_encoding(argv[0]);

  for(I=1;argc>I&&(*argv[I]=='+'||*argv[I]=='-'||*argv[I]=='/');I++) {
    if(isdigit(argv[I][1])){
      int code;
      if(sscanf(argv[I]+1,"%d",&code)!=1){
        print_short_help(); return 0;
      }
      if((code<1)||(code>TOTAL_ENCODING_NUMBER)){
        print_short_help(); return 0;
      }
      if(*argv[I]=='+') force=code-1; else enc=code-1;
      continue;
    }
    switch(argv[I][1]) {
    default: help=2; goto do_help;
    case 'e': case 'E':
      Russian=0; break;
    case 'v': version=1; break;
    case 'h': case '?':  help=1; break;
    case 'H': Help=1;  break;
    case 't': wt="wt"; break;
    case 'p': do_pipe=1; break;
    case 's': silent=1; break;
    case 'a': case 'A': if(*argv[I]=='+') force=0; else enc=0; break;
    case 'w': case 'W': if(*argv[I]=='+') force=1; else enc=1; break;
    case 'k': case 'K': if(*argv[I]=='+') force=2; else enc=2; break;
    case 'i': case 'I': if(*argv[I]=='+') force=3; else enc=3; break;
    case 'm': case 'M': if(*argv[I]=='+') force=4; else enc=4; break;
    case 'q': case 'Q': chkQP = 1; break;
    }
    if(argv[I][2]) help=2;
  }
  do_help:
  if(help) { print_short_help(); return help-1; }
  if(Help) { print_long_help(); return Help-1; }

  if(version)  print_version();

  if (I + 2 < argc) {
    print_short_help();
  }else if(I == argc){
#   ifdef D_ALT
    if(!do_pipe){
      fprintf(stderr,msg(msg_pipe));
      fprintf(stderr,msg(msg_tryhelp));
      exit(0);
    }
#   endif
    filename=NULL;
    outfname=NULL;
    samefile=0;
  }else if (I + 1 == argc) {
    filename=argv[I];
    outfname=NULL;
    samefile=0;
  }else if (I + 2 == argc) {
    struct stat inbuf;
    struct stat outbuf;
    filename=argv[I];
    outfname=argv[I+1];
    if(stat(filename,&inbuf)<0){
      perror(filename);
    }
    if(stat(outfname,&outbuf)<0){
      samefile=0;
    }else{
      samefile=samebuf(&inbuf,&outbuf);
    }
  }
  
  do_recode(filename,outfname,enc,force,chkQP,wt,samefile,silent);
  return 0;
}
