/*  SRECODE.C (Shuffle RECODE) . 1.0
 * Library SRECODE.C (Shuffle RECODE) ver. 1.0

 *  : ..̣,  2002-- 2003
 * : http://www.rusf.ru/books/yo

 *    , 
 *   14 
 *     .

 * Functions for Perl, providing exchange
 * transformation of 14 russian encodings to
 * each other.

 *    -ware, ,  
 *   ,  
 *     ,   
 *  . ,   , 
 *       ,
 *    :  
 *     
 *  .

 *     
 * ģ      
 *      
 * .   ,  
 *  ӣ ,    
 *  .

 * Written by D.V. Khmelev, March 2002 -- April 2003
 * More information at http://www.rusf.ru/books/yo

 * The following code is YO-ware. YO-ware means that
 * you can freely copy, modify and disassemble it in
 * binary and/or source text.  However, if you use
 * this program code, you should use Russian letter
 * YO in all texts in Russian you type in computer
 * from e-mails to novels.

 * The author disclaims any responsibility for code
 * safety and holds no responsibility for the loss of
 * data, resulting the the use of the following
 * code. However, the author tried to do his best to
 * avoid loss of data.
 */

typedef enum {
  CP866=0,
  CP1251,
  KOI8_R,
  ISO8859_5,
  MAC,
  OSN,
  MOSHKOV,
  SORT,
  ALT_FIDO,
  KOI7,
  DKOI,
  CP500,
  EBCDIC,
  ASCII,
  TOTAL_ENCODING_NUMBER} encoding_t;

char * encoding_name[]={
  "cp866", /* CP866 */
  "cp1251", /* CP1251 */
  "koi8-r", /* KOI8_R */
  "iso8859-5", /* ISO8859_5 */
  "mac", /* MAC */
  "osn", /* OSN */
  "moshkov", /* MOSHKOV */
  "sort", /* SORT */
  "alt-fido", /* ALT_FIDO */
  "koi7", /* KOI7 */
  "dkoi", /* DKOI */
  "cp500", /* CP500 */
  "ebcdic", /* EBCDIC */
  "ascii", /* ASCII */
};
unsigned char * encoding_alphabet[]={
  /* CP866 */
  (unsigned char*)
  "\240\241\242\243\244\245\361\246\247\250"
  "\251\252\253\254\255\256\257\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\200\201\202\203\204\205\360\206\207\210"
  "\211\212\213\214\215\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* CP1251 */
  (unsigned char*)
  "\340\341\342\343\344\345\270\346\347\350"
  "\351\352\353\354\355\356\357\360\361\362"
  "\363\364\365\366\367\370\371\372\373\374"
  "\375\376\377"
  "\300\301\302\303\304\305\250\306\307\310"
  "\311\312\313\314\315\316\317\320\321\322"
  "\323\324\325\326\327\330\331\332\333\334"
  "\335\336\337",
  /* KOI8_R */
  (unsigned char*)
  "\301\302\327\307\304\305\243\326\332\311"
  "\312\313\314\315\316\317\320\322\323\324"
  "\325\306\310\303\336\333\335\337\331\330"
  "\334\300\321"
  "\341\342\367\347\344\345\263\366\372\351"
  "\352\353\354\355\356\357\360\362\363\364"
  "\365\346\350\343\376\373\375\377\371\370"
  "\374\340\361",
  /* ISO8859_5 */
  (unsigned char*)
  "\320\321\322\323\324\325\361\326\327\330"
  "\331\332\333\334\335\336\337\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\260\261\262\263\264\265\241\266\267\270"
  "\271\272\273\274\275\276\277\300\301\302"
  "\303\304\305\306\307\310\311\312\313\314"
  "\315\316\317",
  /* MAC */
  (unsigned char*)
  "\340\341\342\343\344\345\336\346\347\350"
  "\351\352\353\354\355\356\357\360\361\362"
  "\363\364\365\366\367\370\371\372\373\374"
  "\375\376\337"
  "\200\201\202\203\204\205\335\206\207\210"
  "\211\212\213\214\215\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* OSN */
  (unsigned char*)
  "\320\321\322\323\324\325\361\326\327\330"
  "\331\332\333\334\335\336\337\340\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\260\261\262\263\264\265\360\266\267\270"
  "\271\272\273\274\275\276\277\300\301\302"
  "\303\304\305\306\307\310\311\312\313\314"
  "\315\316\317",
  /* MOSHKOV */
  (unsigned char*)
  "\341\342\367\347\344\345\243\366\372\351"
  "\352\353\354\355\356\357\360\362\363\364"
  "\365\346\350\343\376\373\375\256\371\370"
  "\374\340\361"
  "\301\302\327\307\304\305\263\326\332\311"
  "\312\313\314\315\316\317\320\322\323\324"
  "\325\306\310\303\336\333\335\254\331\330"
  "\334\300\321",
  /* SORT */
  (unsigned char*)
  "\241\242\243\244\245\246\247\250\251\252"
  "\253\254\255\256\257\260\261\262\263\264"
  "\265\266\267\270\271\272\273\274\275\276"
  "\277\300\301"
  "\200\201\202\203\204\205\206\207\210\211"
  "\212\213\214\215\216\217\220\221\222\223"
  "\224\225\226\227\230\231\232\233\234\235"
  "\236\237\240",
  /* ALT_FIDO */
  (unsigned char*)
  "\240\241\242\243\244\245\361\246\247\250"
  "\251\252\253\254\255\256\257\160\341\342"
  "\343\344\345\346\347\350\351\352\353\354"
  "\355\356\357"
  "\200\201\202\203\204\205\360\206\207\210"
  "\211\212\213\214\110\216\217\220\221\222"
  "\223\224\225\226\227\230\231\232\233\234"
  "\235\236\237",
  /* KOI7 */
  (unsigned char*)
  "\101\102\127\107\104\105\43\126\132\111"
  "\112\113\114\115\116\117\120\122\123\124"
  "\125\106\110\103\136\133\135\137\131\130"
  "\134\100\121"
  "\141\142\167\147\144\145\44\166\172\151"
  "\152\153\154\155\156\157\160\162\163\164"
  "\165\146\150\143\176\173\175\42\171\170"
  "\174\140\161",
  /* DKOI */
  (unsigned char*)
  "\167\170\257\215\212\213\131\256\262\217"
  "\220\232\233\234\235\236\237\252\253\254"
  "\255\214\216\200\266\263\265\267\261\260"
  "\264\166\240"
  "\271\272\355\277\274\275\102\354\372\313"
  "\314\315\316\317\332\333\334\336\337\352"
  "\353\276\312\273\376\373\375\165\357\356"
  "\374\270\335",
  /* CP500 */
  (unsigned char*)
  "\254\151\355\356\353\357\111\354\277\200"
  "\375\376\373\374\255\256\131\104\105\102"
  "\106\103\107\234\110\124\121\122\123\130"
  "\125\126\127"
  "\220\217\352\372\276\240\252\266\263\235"
  "\332\233\213\267\270\271\253\144\145\142"
  "\146\143\147\236\150\164\161\162\163\170"
  "\165\166\167",
  /* EBCDIC */
  (unsigned char*)
  "\237\240\252\253\254\255\335\256\257\260"
  "\261\262\263\264\265\266\267\270\271\272"
  "\273\274\275\276\277\312\313\314\315\316"
  "\317\332\333"
  "\130\131\142\143\144\145\102\146\147\150"
  "\151\160\161\162\163\164\165\166\167\170"
  "\200\212\213\214\215\216\217\220\232\233"
  "\234\235\236",
  /* ASCII */
  (unsigned char*)
  "\141\142\167\147\144\145\136\166\172\151"
  "\152\153\154\155\156\157\160\162\163\164"
  "\165\146\150\143\75\133\135\43\171\170"
  "\134\140\161"
  "\101\102\127\107\104\105\46\126\132\111"
  "\112\113\114\115\116\117\120\122\123\124"
  "\125\106\110\103\53\173\175\44\131\130"
  "\174\176\121",
};

int *full_encoding_list(encoding_t encoding,
                        int table[]){
  int i,j;
  static int exists[256];
  for(i=0;i<256;i++) exists[i]=0;
  for(i=0;i<66;i++) {
    table[i]=encoding_alphabet[encoding][i];
    exists[table[i]]=1;
  }
  for(j=66,i=0;i<256;i++){
    if(exists[i]) continue;
    table[j++]=i;
  }
  return table;
}


int *fill_recode_table(int table[],
                       encoding_t from,
                       encoding_t to){
  static int full_enc_from[256];
  static int full_enc_to[256];
  int i;
  full_encoding_list(from,full_enc_from);
  full_encoding_list(to,full_enc_to);
  for(i=0;i<256;i++)
    table[full_enc_from[i]]=full_enc_to[i];
  return table;
}

unsigned char *srecode(unsigned char *s,
                       encoding_t from,
                       encoding_t to){
  static int prev_from=-1, prev_to=-1;
  static int recode_table[256]; 
  int i;
  if((from!=prev_from)||(to!=prev_to)){
    prev_from=from; prev_to=to;
    fill_recode_table(recode_table,from,to);
  }
  for(i=0;s[i];i++) s[i]=recode_table[s[i]];
  return s;
}

unsigned char *srecode2(unsigned char *s,
                        unsigned char *t,
                        encoding_t from,
                        encoding_t to){
  static int prev_from=-1, prev_to=-1;
  static int recode_table[256]; 
  int i;
  if((from!=prev_from)||(to!=prev_to)){
    prev_from=from; prev_to=to;
    fill_recode_table(recode_table,from,to);
  }
  for(i=0;t[i];i++) s[i]=recode_table[t[i]];
  s[i]=0;
  return s;
}

/*    SRECODE.C          *
 * end of the code of the library SRECODE.C */
