#!/usr/bin/perl
#  SRECODE.PL (Shuffle RECODE) . 1.0
# Library SRECODE.PL (Shuffle RECODE) ver. 1.0

#  : ..̣,  2002-- 2003
# : http://www.rusf.ru/books/yo

#    , 
#   14 
#     .

# Functions for Perl, providing exchange
# transformation of 14 russian encodings to
# each other.

#    -ware, ,  
#   ,  
#     ,   
#  . ,   , 
#       ,
#    :  
#     
#  .

#     
# ģ      
#      
# .   ,  
#  ӣ ,    
#  .


# Written by D.V. Khmelev, March 2002 -- April 2003
# More information at http://www.rusf.ru/books/yo

# The following code is YO-ware. YO-ware means that
# you can freely copy, modify and disassemble it in
# binary and/or source text.  However, if you use
# this program code, you should use Russian letter
# YO in all texts in Russian you type in computer
# from e-mails to novels.

# The author disclaims any responsibility for code
# safety and holds no responsibility for the loss of
# data, resulting the the use of the following
# code. However, the author tried to do his best to
# avoid loss of data.

%CODE_TABLE=(
 "cp866" =>
   "\240-\245\361\246-\257\340-\357\200-\205".
  "\360\206-\237\0-\177\260-\337\362-\377",
 "cp1251" =>
   "\340-\345\270\346-\377\300-\305\250".
  "\306-\337\0-\247\251-\267\271-\277",
 "koi8-r" =>
   "\301\302\327\307\304\305\243".
  "\326\332\311-\320\322-\325\306".
  "\310\303\336\333\335".
  "\337\331\330\334\300".
  "\321\341\342\367\347\344\345".
  "\263\366\372\351-\360\362-\365".
  "\346\350\343\376\373".
  "\375\377\371\370\374".
  "\340\361\0-\242\244-\262\264-\277",
 "iso8859-5" =>
   "\320-\325\361\326-\357\260-\265\241".
  "\266-\317\0-\240\242-\257\360\362-\377",
 "mac" =>
   "\340-\345\336\346-\376\337\200-\205".
  "\335\206-\237\0-\177\240-\334\377",
 "osn" =>
   "\320-\325\361\326-\357\260-\265\360".
  "\266-\317\0-\257\362-\377",
 "moshkov" =>
   "\341\342\367\347\344\345\243".
  "\366\372\351-\360\362-\365\346".
  "\350\343\376\373\375".
  "\256\371\370\374\340".
  "\361\301\302\327\307\304\305".
  "\263\326\332\311-\320\322-\325".
  "\306\310\303\336\333".
  "\335\254\331\330\334".
  "\300\321\0-\242\244-\253\255".
  "\257-\262\264-\277\337\377",
 "sort" =>
   "\241-\301\200-\240\0-\177\302-\377",
 "alt-fido" =>
   "\240-\245\361\246-\257\160\341-\357".
  "\200-\205\360\206-\214\110\216-\237".
  "\0-\107\111-\157\161-\177\215\260-\340".
  "\362-\377",
 "koi7" =>
   "\101\102\127\107\104\105\43".
  "\126\132\111-\120\122-\125\106".
  "\110\103\136\133\135".
  "\137\131\130\134\134\100".
  "\121\141\142\167\147\144\145".
  "\44\166\172\151-\160\162-\165".
  "\146\150\143\176\173".
  "\175\42\171\170\174".
  "\140\161\0-\41\45-\77\177-\377",
 "dkoi" =>
   "\167\170\257\215\212\213\131".
  "\256\262\217\220\232-\237\252-\255".
  "\214\216\200\266\263".
  "\265\267\261\260\264".
  "\166\240\271\272\355\277".
  "\274\275\102\354\372\313-\317".
  "\332-\334\336\337\352\353\276\312".
  "\273\376\373\375\165".
  "\357\356\374\270\335".
  "\0-\101\103-\130\132-\164\171-\177\201-\211".
  "\221-\231\241-\251\300-\311\320-\331\340-\351".
  "\360-\371\377",
 "cp500" =>
   "\254\151\355\356\353\357".
  "\111\354\277\200\375\376".
  "\373\374\255\256\131\104\105\102".
  "\106\103\107\234\110".
  "\124\121-\123\130\125-\127\220".
  "\217\352\372\276\240".
  "\252\266\263\235\332".
  "\233\213\267-\271\253\144\145".
  "\142\146\143\147\236".
  "\150\164\161-\163\170\165-\167".
  "\0-\101\112-\120\132-\141\152-\160\171-\177".
  "\201-\212\214-\216\221-\232\237\241-\251".
  "\257-\262\264\265\272-\275\300-\331\333-\351".
  "\360-\371\377",
 "ebcdic" =>
   "\237\240\252-\255\335\256-\277\312-\317".
  "\332\333\130\131\142-\145\102\146-\151".
  "\160-\170\200\212-\220\232-\236\0-\101".
  "\103-\127\132-\141\152-\157\171-\177\201-\211".
  "\221-\231\241-\251\300-\311\320-\331\334".
  "\336-\377",
 "ascii" =>
   "\141\142\167\147\144\145\136".
  "\166\172\151-\160\162-\165\146".
  "\150\143\75\133\135".
  "\43\171\170\134\134\140".
  "\161\101\102\127\107\104\105".
  "\46\126\132\111-\120\122-\125".
  "\106\110\103\53\173".
  "\175\44\131\130\174".
  "\176\121\0-\42\45\47-\52".
  "\54-\74\76-\100\137\177-\377",
);

#############################################
#     .
#   %CODE_TABLE, 
# ̣ .  :
# Ex: $str=recode_var($str, $from, $to);
#
# Recode text  and return its content. 
# Uses %CODE_TABLE defined above.
# Ex: $str=recode_var($str, $from, $to);
#############################################

sub recode_var {
 my ($text, $from, $to) = @_;
 if (!$from){ 
   die"Recode error: Source encoding is not set.";
 }
 if (!$CODE_TABLE{$from}){
  die
  "Recode error: Undefined source code set ($from).";
 }
 if (!$to){ 
  die"Recode error: Destination encoding is not set.";
 }
 if (!$CODE_TABLE{$to}){
  die"Recode error: Undefined destination code set ($to).";
 }
 $_ = $text;
 eval "tr/$CODE_TABLE{$from}/$CODE_TABLE{$to}/";
 return $_;
}

sub testencs{
  my $teststr= #all letters in KOI-8 encoding
   "\301\302\327\307\304\305\243\326\332".
   "\311\312\313\314\315\316\317\320".
   "\322\323\324\325\306\310\303\336".
   "\333\335\337\331\330\334\300\321".
   "\341\342\367\347\344\345\263\366\372".
   "\351\352\353\354\355\356\357\360".
   "\362\363\364\365\346\350\343\376".
   "\373\375\377\371\370\374\340\361";
  my ($to1,$to2);
  foreach $to1(keys %CODE_TABLE){
    my $res1=recode_var($teststr,"koi8-r",$to1);
    foreach $to2(keys %CODE_TABLE){
      my $res2=recode_var($res1,$to1,$to2);
      if(!(recode_var($res2,$to2,"koi8-r") eq $teststr)){
        die 
        "Unsuccesful recoding: koi8-r->$to1->$to2->koi8-r";
      }
    }
  }
  print "No information losses for all the encodings!\n";
}

testencs();
